#ifndef INTERFACES_HPP
#define INTERFACES_HPP

class IPlayerInput
{
  public:
    virtual void doStart() = 0;
    virtual void doStop() = 0;
    virtual void doPause() = 0;
};

class IPlayerEvent
{
  public:
    virtual void started() = 0;
    virtual void stopped() = 0;
    virtual void paused() = 0;
};

class IUiInput
{
  public:
    virtual void sayPlay() = 0;
    virtual void sayStop() = 0;
    virtual void sayPause() = 0;
};

class IUiEvent
{
  public:
    virtual void playPause() = 0;
    virtual void stop() = 0;
};

#endif // INTERFACES_HPP
